<?php

namespace App\Enums;

enum ChargeTypes: string
{
    case Recurring = 'recurring';
    case Fixed = 'fixed';
    case Days = 'days';
    case Free = 'free';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function forSelect(): array 
    {
        return array_combine(
            array_column(self::cases(), 'value'),
            array_column(self::cases(), 'name')
        );
    }
}