<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;

enum ContainerSizes: string implements HasLabel
{
    case TWENTY_FIT = "20_gp";
    case TWENTY_FIT_HC = "20_hc";
    case FORTY_FIT = "40_gp";
    case FORTY_FIT_HC = "40_hc";

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::TWENTY_FIT => "20' GP",
            self::TWENTY_FIT_HC => "20' HC",
            self::FORTY_FIT => "40' GP",
            self::FORTY_FIT_HC => "40' HC",
        };
    }
    
    public function getTue(): ?int
    {
        return match ($this) {
            self::TWENTY_FIT => 1,
            self::TWENTY_FIT_HC => 1,
            self::FORTY_FIT => 2,
            self::FORTY_FIT_HC => 2,
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::TWENTY_FIT => 'cyan',
            self::TWENTY_FIT_HC => 'primary',
            self::FORTY_FIT => 'teal',
            self::FORTY_FIT_HC => 'info',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::TWENTY_FIT => 'heroicon-o-home-modern',
            self::TWENTY_FIT_HC => "heroicon-o-briefcase",
            self::FORTY_FIT => "heroicon-o-building-library",
            self::FORTY_FIT_HC => "heroicon-o-document-text",
        };
    }
}