<?php

namespace App\Filament\Office\Resources\BLResource\Pages;

use App\Models\BL;
use Filament\Actions;
use App\Filament\Forms\BLForms;
use Filament\Actions\Action;
use Filament\Resources\Pages\ListRecords;
use App\Filament\Office\Resources\BLResource;

class ListBLS extends ListRecords
{
    protected static string $resource = BLResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('report')
            ->icon('heroicon-m-newspaper')
            ->color('lime')
            ->form([
                BLForms::reportGenForm()
            ])
            ->action(function (array $data): void {
                // dd(http_build_query($data));
                // dd($data);
                // $record->author()->associate($data['posted_by_user_id']);
                // $record->save();

                redirect(route('shipping.bl.report').'/?'.http_build_query($data));
            }),
            Actions\CreateAction::make(),
        ];
    }
}
