<?php

namespace App\Filament\Office\Resources\CompanyResource\Pages;

use App\Filament\Office\Resources\CompanyResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateCompany extends CreateRecord
{
    protected static string $resource = CompanyResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // dd(collect(auth()->user()->getOfficesID())->first());
        $data['office_id'] = collect(auth()->user()->getOfficesID())->first();

        $data['code'] = strtoupper($data['code']);

        return $data;
    }
}
