<?php

namespace App\Filament\Office\Resources\ScheduleResource\RelationManagers;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\RelationManagers\RelationManager;

class TransitsRelationManager extends RelationManager
{
    protected static string $relationship = 'transits';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('port_of_loading_id')
                    ->relationship('port_of_loading', 'name')
                    ->searchable(['name', 'iso'])
                    ->required(),
                Forms\Components\TextInput::make('pol_voy'),
                Forms\Components\Select::make('port_of_discharge_id')
                    ->relationship('port_of_discharge', 'name')
                    ->searchable(['name', 'iso'])
                    ->required(),
                Forms\Components\TextInput::make('pod_voy'),

                Forms\Components\DatePicker::make('eta')
                    ->required(),
                Forms\Components\DatePicker::make('etb')
                    ->required(),
                Forms\Components\DatePicker::make('etd')
                    ->required(),

                Forms\Components\TextInput::make('string'),
                Forms\Components\TextInput::make('reg_no'),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('port_of_loading')
                    ->formatStateUsing(fn($state):string => $state->name . ' (' . $state->iso . ')')
                    ->description(fn(?Model $record):string => 'V-' . $record->pol_voy . ' ⋅ ' . date('d M, Y', strtotime($record->eta))),
                Tables\Columns\TextColumn::make('port_of_discharge')
                    ->formatStateUsing(fn($state):string => $state->name . ' (' . $state->iso . ')')
                    ->description(fn(?Model $record):string => 'V-' . $record->pod_voy . ' ⋅ ' . date('d M, Y', strtotime($record->etd))),
                Tables\Columns\TextColumn::make('etb')
                    ->formatStateUsing(fn($state):string => date('d M, Y', strtotime($state)))
                    ->label('Berth'),
                Tables\Columns\TextColumn::make('string')
                    ->description(fn(?Model $record):string => 'Reg: ' . $record->reg_no),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
