<?php

namespace App\Filament\Office\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\ServiceRoute;
use Filament\Infolists\Infolist;
use Filament\Resources\Resource;
use App\Tables\Columns\NextVoyage;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Office\Resources\ServiceRouteResource\Pages;
use App\Filament\Office\Resources\ServiceRouteResource\RelationManagers;

class ServiceRouteResource extends Resource
{
    protected static ?string $model = ServiceRoute::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $slug = 'shipping/service-routes';
    
    protected static ?string $navigationGroup = 'Shipping';
    protected static ?string $navigationLabel = 'Service Routes';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->datalist([
                        'Caribbean',
                        'Central America',
                        'North America',
                        'South America',
                        'Central Asia',
                        'East Asia',
                        'South Asia',
                        'South East Asia',
                        'Central Europe',
                        'Eastern Europe',
                        'Nordic countries',
                        'Southern Europe',
                        'Western Europe',
                        'Middle East',
                        'North Africa',
                        'Australia',
                        'New Zealand',
                        'Pacific Islands',
                        'Central Africa',
                        'East Africa',
                        'Southern Africa',
                        'West Africa',
                    ])
                    ->required(),
                Forms\Components\Select::make('port_of_loading_id')
                    ->relationship('port_of_loading', 'name')
                    ->searchable(['name', 'iso']),
                Forms\Components\Select::make('port_of_discharge_id')
                    ->relationship('port_of_discharge', 'name')
                    ->searchable(['name', 'iso']),

                Forms\Components\Toggle::make('active')
                    ->required(),
                
                Forms\Components\Select::make('ports')
                    ->relationship('ports', 'name')
                    ->multiple(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                // Tables\Columns\TextColumn::make('sn')
                //     ->rowIndex(),
                Tables\Columns\TextColumn::make('name')
                    ->label('Route Name')
                        ->description(function(?Model $record):string {
                            $desc = 'POL: ' . $record->port_of_loading->name . ' (' . $record->port_of_loading->iso . ')';
                            $desc .= ' ⋅ ';
                            $desc .= 'POD: ' . $record->port_of_discharge->name . ' (' . $record->port_of_discharge->iso . ')';
                            return $desc;
                        })
                    ->searchable(),
                NextVoyage::make('next_voyage')
                    ->label('Next Voyage'),
                Tables\Columns\TextColumn::make('service_ports')
                    ->label('Connecting Ports')
                    ->formatStateUsing(fn($state):string => $state->port->name . ' (' . $state->port->iso . ')')
                    ->badge(),
                Tables\Columns\IconColumn::make('active')
                    ->boolean(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->modifyQueryUsing(fn (Builder $query) => $query->with('schedules'));
    }


    public static function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListServiceRoutes::route('/'),
            'create' => Pages\CreateServiceRoute::route('/create'),
            'view' => Pages\ViewServiceRoute::route('/{record}'),
            'edit' => Pages\EditServiceRoute::route('/{record}/edit'),
        ];
    }
}
