<?php

namespace App\Filament\Office\Resources;

use App\Models\BL;
use Filament\Forms;
use Filament\Tables;
use App\Models\Vessel;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Office\Resources\VesselResource\Pages;
use App\Filament\Office\Resources\VesselResource\RelationManagers;

class VesselResource extends Resource
{
    protected static ?string $model = Vessel::class;

    protected static ?string $slug = 'settings/vessels';

    protected static ?string $navigationGroup = 'Settings';
    protected static ?string $navigationIcon = 'heroicon-o-table-cells';
    
    public static function shouldRegisterNavigation(): bool
    {
        return auth()->user()?auth()->user()->can('viewAny', BL::class):false;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->required(),
                Forms\Components\TextInput::make('code')
                    ->required()
                    ->unique(ignoreRecord: true)
                    ->maxLength(8)
                    ->minLength(3),
                Forms\Components\TextInput::make('capacity')
                    ->label('Capacity (TEUs)')
                    ->numeric()
                    ->required(),
                Forms\Components\Select::make('route_start')
                    ->label('Route Start (Port)')
                    ->required()
                    ->searchable()
                    ->relationship('route_start_data', 'name'),
                Forms\Components\Select::make('route_end')
                    ->label('Route End (Port)')
                    ->required()
                    ->searchable()
                    ->relationship('route_end_data', 'name'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->formatStateUsing(fn(?Model $record): string => $record->name . ' (' . $record->code . ')')
                    ->searchable(['name', 'code']),
                Tables\Columns\TextColumn::make('capacity')
                    ->numeric(
                        decimalPlaces: 0,
                        decimalSeparator: '.',
                        thousandsSeparator: ',',
                    )
                    ->searchable(),
                Tables\Columns\TextColumn::make('route_start_data.name')
                    ->label('Route Start')
                    ->formatStateUsing(fn (Vessel $record): string => $record->route_start_data->name . (!empty($record->route_start_data->iso)?' (' . $record->route_start_data->iso . ')':''))
                    ->sortable(),
                Tables\Columns\TextColumn::make('route_end_data.name')
                    ->label('Route End')
                    ->formatStateUsing(fn (Vessel $record): string => $record->route_end_data->name . (!empty($record->route_end_data->iso)?' (' . $record->route_end_data->iso . ')':''))
                    ->sortable(),
                // Tables\Columns\TextColumn::make('created_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
                // Tables\Columns\TextColumn::make('updated_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
                // Tables\Columns\TextColumn::make('deleted_at')
                //     ->dateTime()
                //     ->sortable(),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }
    
    public static function getRelations(): array
    {
        return [
            //
        ];
    }
    
    public static function getPages(): array
    {
        return [
            'index' => Pages\ListVessels::route('/'),
            'create' => Pages\CreateVessel::route('/create'),
            'edit' => Pages\EditVessel::route('/{record}/edit'),
        ];
    }    
    
    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
