<?php

namespace App\Filament\Office\Resources\VesselResource;

use Filament\Forms;

final class VesselForms
{
    static public function getVesselAddForm() : Forms\Components\Grid {
        return Forms\Components\Grid::make('Add New Delivery Agent')->schema([
            Forms\Components\TextInput::make('name')
                ->unique(ignorable: fn ($record) => $record)
                ->helperText('Write new vessel name here')
                ->minLength(3)
                ->maxLength(100),
            Forms\Components\TextInput::make('capacity')
                ->helperText('Capacity with tues')
                ->minLength(1),
            Forms\Components\Select::make('route_start')
                ->label('Starting Port')
                ->relationship('port_start', 'name')
                ->searchable(),
            Forms\Components\Select::make('route_end')
                ->label('Destination Port')
                ->relationship('port_end', 'name')
                ->searchable(),
        ])->columns(2);
    }
}
