<?php

namespace App\Filament\Resources\CompanyResource\Pages;

use Filament\Actions;
use App\Models\Company;
use App\Classes\QueryCount;
use App\Enums\CompanyTypes;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Filament\Resources\Pages\ListRecords;
use App\Filament\Resources\CompanyResource;
use Filament\Resources\Components\Tab;

class ListCompanies extends ListRecords
{
    protected static string $resource = CompanyResource::class;
    protected $model = Company::class;
    protected QueryCount $query_count;

    public function __construct() {
        $this->query_count = new QueryCount($this->model, 'type');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            null => Tab::make('All')->badge($this->query_count->getBadgeCount()),
            CompanyTypes::WAREHOUSE->value => Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::WAREHOUSE))
                // ->icon(CompanyTypes::WAREHOUSE->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::WAREHOUSE->value))
                ->badgeColor('gray'),
            CompanyTypes::COMPANY->value => Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::COMPANY->value))
                // ->icon(CompanyTypes::COMPANY->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::COMPANY->value))
                ->badgeColor('success'),
            CompanyTypes::BANK->value => Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::BANK->value))
                // ->icon(CompanyTypes::BANK->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::BANK->value))
                ->badgeColor('danger'),
            CompanyTypes::CNF->value => Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::CNF->value))
                // ->icon(CompanyTypes::CNF->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::CNF->value))
                ->badgeColor('warning'),
        ];
    }
}
