<?php

namespace App\Filament\Tables;

use App\Traits\BLHelper;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Model;
use Filament\Tables\Columns\ToggleColumn;

final class BLTables
{
    static public function blTable($customer=false) : array {
        return [
            TextColumn::make('bl_no')
                ->label('BL Number')
                // ->description(fn (?Model $record): string => 'POL: '.$record->place_of_loading->name . ' (' . $record->place_of_loading->iso . ')' . ' ⭢ POD: ' . $record->port_of_discharge->name . ' (' . $record->port_of_discharge->iso . ')')
                ->description(fn (?Model $record): string => (!empty($record->place_of_loading) && !empty($record->port_of_discharge))?($record->place_of_loading->name . ' (' . $record->place_of_loading->iso . ')' . ' → ' . $record->port_of_discharge->name . ' (' . $record->port_of_discharge->iso . ')'):'')
                ->searchable()
                ->icon(fn(?Model $record)=>BLHelper::getIcon($record->locked, $record->is_final))
                ->iconPosition('after')
                ->iconColor(fn(?Model $record)=>BLHelper::getColor($record->locked, $record->is_final))
                ->sortable(),
            TextColumn::make('etd')
                ->label('ETD')
                ->formatStateUsing(fn (string $state): string => \Carbon\Carbon::parse($state)->toFormattedDateString())
                ->description(fn (?Model $record): string => 'ETA: ' . \Carbon\Carbon::parse($record->eta)->toFormattedDateString())
                ->searchable()
                ->sortable(),
            TextColumn::make('booking_ref_no')
                ->label('Booking No.')
                ->sortable()
                ->searchable()
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('ocean_vessel.name')
                ->label('Ocean Vessel')
                ->sortable()
                ->searchable(isIndividual: true)
                ->toggleable(isToggledHiddenByDefault: false),
            TextColumn::make('ocean_vessel_voy.voy_no')
                ->label('Voyage')
                ->sortable()
                ->searchable(isIndividual: true)
                ->toggleable(isToggledHiddenByDefault: false),
            TextColumn::make('ocean_vessel_old')
                ->label('Ocean Vessel (Old)')
                ->sortable()
                ->searchable(isIndividual: true)
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('voy_no_destination_old')
                ->label('Voyage (Old)')
                ->sortable()
                ->searchable(isIndividual: true)
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('pre_carriage_vessel')
                ->label('Vessel (Pre)')
                ->description(fn (?Model $record): string => 'Voy: '.$record->voy_no_pre_carriage)
                ->sortable()
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('final_destination')
                ->label('Final Destination')
                // ->description(fn (?Model $record): string => $record->final_destination_city->name.' ⋅ '.$record->final_destination_country->name)
                ->sortable(),
            TextColumn::make('issue_date')
                ->label('Issued')
                ->formatStateUsing(fn (string $state): string => \Carbon\Carbon::parse($state)->diffForHumans())
                ->description(fn (?Model $record): string => $record->place_issue)
                ->sortable()
                ->toggleable(isToggledHiddenByDefault: true),
            ToggleColumn::make('locked'),
            TextColumn::make('bl_containers_count')
                ->counts('bl_containers')
                ->formatStateUsing(fn ($state): string => $state . ($state>1?' Units':' Unit'))
                ->description(function(?Model $record) : string {
                    return BLHelper::tues($record->bl_containers);
                })
                ->hidden($customer)
                ->label('Count')
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('bl_containers')
                ->badge()
                ->label('Container List')
                ->color(fn ($state): string => $state->container_size->getColor())
                ->formatStateUsing(fn ($state): string => BLHelper::container_list($state))
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('created_at')
                ->dateTime()
                ->sortable()
                ->label('Created')
                ->description(function(?Model $record) : string|null {
                    // if (!empty($record->posted_by_user_id)) {
                    //     $model = match ($record->posted_user_type) {
                    //         1 => User::class,
                    //         2 => OfficeUser::class,
                    //     };
                    //     $user = $model::find($record->posted_by_user_id)->first();
                    //     return $user->name;
                    // }
                    // return $record->posted_by_user_id;

                    $activity = $record->activities()->where('event', 'created')->with('causer')->latest()->first();
                    $user_type = ' (Customer)';
                    if (!empty($activity->causer_type) && $activity->causer_type == 'App\Models\OfficeUser') {
                        $user_type = ' (Office)';
                    }
                    return !empty($activity->causer)?($activity->causer?->name . $user_type):null;
                })
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('updated_at')
                ->dateTime()
                ->sortable()
                ->label('Updated')
                ->description(function(?Model $record) : string|null {
                    $activity = $record->activities()->where('event', 'updated')->with('causer')->latest()->first();
                    $user_type = ' (Customer)';
                    if (!empty($activity->causer_type) && $activity->causer_type == 'App\Models\OfficeUser') {
                        $user_type = ' (Office)';
                    }
                    return !empty($activity->causer)?($activity->causer?->name . $user_type):null;
                })
                ->toggleable(isToggledHiddenByDefault: true),
            TextColumn::make('deleted_at')
                ->dateTime()
                ->sortable()
                ->toggleable(isToggledHiddenByDefault: true),
        ];
    }
}
