<?php

namespace App\Http\Controllers;

use App\Models\BL;
use App\Models\OldBL;
use Illuminate\Http\Request;

class TrackingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tracking = null;

        $bl_no = request('bl');
        $container = request('container');

        $tracking = $this->getBL($bl_no, $container);

        if (empty($tracking) && OldBL::where('bl_no', $bl_no)->exists()) {
            return redirect('https://sealloyd.com/track/result.php?search='.$bl_no);
        }

        return view('tracking.result', compact('tracking'));
    }

    function getBL($bl_no=null, $container=null) : BL|NULL {
        // return BL::where('bl_no', $bl_no)
        return BL::where('bl_no', 'LIKE', "%{$bl_no}%")
            ->whereHas('bl_containers', function ($query) use ($container){
                $query->where('container_num', 'LIKE', "%{$container}%");
                // $query->where('container_num', $container);
            })
            ->with(['bl_containers', 'place_of_loading', 'port_of_discharge', 'trackings' => function($query){
                $query->with('status');
            }])
            ->withoutGlobalScopes([
                // SoftDeletingScope::class,
                'organization',
                'office'
            ])->first();
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
