<?php

namespace App\Mail;

use App\Models\BL;
use App\Traits\HasActivity;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Contracts\Queue\ShouldQueue;

class BLCreated extends Mailable
{
    use Queueable, SerializesModels, HasActivity;

    /**
     * Create a new message instance.
     */
    public function __construct(public BL $bl)
    {
        //
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: '#' . $this->bl->bl_no . ' (Bill of Lading) has been created successfully',
            from: new Address('info@sealloyd.com', 'Sea Lloyd Shipping'),
            // replyTo: [
            //     new Address('taylor@example.com', 'Taylor Otwell'),
            //     new Address('itskawsar@gmail.com', 'Kawsar A.'),
            // ],
            // tags: ['shipment'],
            // metadata: [
            //     'shipmentRequest' => $this->bl->id,
            // ],
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.bl.created',
            with: [
                'bl' => $this->bl,
                'activity' => $this->model($this->bl)->getUpdatedActivity()->getData(),
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
