<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BLCertificate extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Get the shipper that owns the BL
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function bl(): BelongsTo
    {
        return $this->belongsTo(BL::class, 'bl_id', 'id');
    }
}
