<?php

namespace App\Models;

use App\Enums\OfficeTypes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Office extends Model
{
    use HasFactory, SoftDeletes;

    protected $casts = [
        'type' => OfficeTypes::class,
    ];

    /**
     * The office_stuff_users that belong to the OfficeUser
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    // public function office_staff_users(): BelongsToMany
    // {
    //     return $this->belongsToMany(OfficeUser::class, 'office_staff', 'office_id', 'office_user_id');
    // }

    /**
     * Get all of the office_staff_users for the Office
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function office_staff_users(): HasMany
    {
        return $this->hasMany(OfficeStaff::class)->with('office_user');
    }

    /**
     * Get all of the ports for the Office
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function ports(): HasMany
    {
        return $this->hasMany(Port::class);
    }

    /**
     * Get the country that owns the Office
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    /**
     * Get the city that owns the Office
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }
}
