<?php

namespace App\Models;

use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Organization extends Model
{
    use HasFactory, SoftDeletes;
    
    /**
     * The "booted" method of the model.
     */
    protected static function booted(): void
    {
        // dd(auth()->user()->office);
        // dd(OfficeUser::where('id', auth()->user()->id)->with('office')->get());
        // static::addGlobalScope('office', function (Builder $builder) {
        //     $builder->where('office_id', auth()->user()->organization_id);
        // });

        static::addGlobalScope('office', function (Builder $builder) {
            if (Auth::user()->is_customer()) {
                return;
            }
            
            $user_offices = OfficeUser::find(Auth::id())->office()->get();
            $user_office_ids = [];
            foreach ($user_offices as $uoffice) {
                $user_office_ids[] = $uoffice->id;
            }
            $builder->whereIn('office_id', $user_office_ids);
        });
    }

    /**
     * Get all of the users for the Organization
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    /**
     * Get all of the BLs for the Organization
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bls(): HasMany
    {
        return $this->hasMany(BL::class);
    }
}
