<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class ServiceRoute extends Model
{
    use HasFactory;

    protected $casts = [
        'connecting_ports' => 'array',
    ];

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function vessel(): BelongsTo
    {
        return $this->belongsTo(Vessel::class, 'vessel_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port_of_loading(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_of_loading_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port_of_discharge(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_of_discharge_id', 'id');
    }

    /**
     * Get all of the schedule for the ServiceRoute
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function schedules(): HasMany
    {
        return $this->hasMany(Schedule::class);
    }

    /**
     * Get all of the schedule for the ServiceRoute
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function ports(): BelongsToMany
    {
        return $this->belongsToMany(Port::class, 'service_ports');
    }
}
