<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Vessel extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Get the route_start_data that owns the Vessel
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function route_start_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'route_start', 'id');
    }

    /**
     * Get the route_end_data that owns the Vessel
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function route_end_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'route_end', 'id');
    }

    /**
     * Get all of the bls for the Vessel
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bls(): HasMany
    {
        return $this->hasMany(BL::class, 'ocean_vessel_id', 'id');
    }
}
