<?php

namespace App\Policies;

use App\Models\Container;
use App\Models\OfficeUser;
use Illuminate\Auth\Access\Response;
use Illuminate\Support\Facades\Auth;

class ContainerPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(OfficeUser $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(OfficeUser $user, Container $container): bool
    {
        return true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(OfficeUser $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(OfficeUser $user, Container $container): bool
    {
        return true;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(OfficeUser $user, Container $container): bool
    {
        return true;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(OfficeUser $user, Container $container): bool
    {
        return true;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restoreAny(OfficeUser $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(OfficeUser $user, Container $container): Response
    {
        return Auth::user()->isSuperAdmin()?
            Response::allow() : 
            Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDeleteAny(OfficeUser $user): Response
    {
        return Auth::user()->isSuperAdmin()?
            Response::allow() : 
            Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }
}
