<?php

namespace App\Policies;

use App\Models\OfficeUser;
use Illuminate\Auth\Access\Response;
use Illuminate\Support\Facades\Auth;

class OfficeUserPolicy
{
    
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(OfficeUser $user): Response | bool
    {
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(OfficeUser $user, OfficeUser $officeUser): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(OfficeUser $user): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(OfficeUser $user, OfficeUser $officeUser): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(OfficeUser $user, OfficeUser $officeUser): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    public function deleteAny(OfficeUser $user): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(OfficeUser $user, OfficeUser $officeUser): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restoreAny(OfficeUser $user): Response
    {
        return Auth::user()->isSuperAdmin() || Auth::user()->isAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(OfficeUser $user, OfficeUser $officeUser): Response
    {
        return Auth::user()->isSuperAdmin()?
                Response::allow() : 
                Response::deny('You do not have rights to do this action, please contact to our administrator.');
    }
}
