<?php

namespace App\Reposotories;

use App\Models\BL;
use Carbon\Carbon;
use NumberFormatter;
use App\Traits\BLHelper;

final class BlReposotories
{

    public function __construct(public BL $bl, public string $dateFormat = 'd M Y') {
        $this->bl = $bl;
        $this->dateFormat = $dateFormat;
    }

    public function setDateFormat($dateFormat='d/m/Y') : object {
        $this->dateFormat = $dateFormat;
        return $this;
    }

    public function getDateFormat() : string {
        return $this->dateFormat;
    }

    public function formatBlData() : object {
        return (object) [
            'bl_id' => $this->bl->id,
            'bl_no' => $this->bl->bl_no,
            'bl_type' => $this->bl->bl_type->getLabel(),
            'cargo_type' => $this->bl->cargo_type->getLabel(),
            // 'loading_type' => $this->bl->loading_type->getLabel(),
            
            'booking_ref_no' => $this->bl->booking_ref_no,
            'shipper_ref' => $this->bl->shipper_ref,
            'original_bl' => $this->bl->original_bl,
            'original_bl_spellout' => $this->getSpellout($this->bl->original_bl),
            'etd' => $this->formatDateData($this->bl->etd),
            'eta' => $this->formatDateData($this->bl->eta),

            'pre_carriage_vessel' => $this->bl->pre_carriage_vessel,
            'voy_no_pre_carriage' => $this->bl->voy_no_pre_carriage,
            'ocean_vessel' => $this->formatVesselData($this->bl->ocean_vessel, $this->bl->ocean_vessel_old),
            'ocean_vessel_voy' => $this->formatVoyageData($this->bl->ocean_vessel_voy, $this->bl->voy_no_destination_old),
            
            'place_of_receipt' => $this->bl->place_of_receipt,
            'place_of_loading' => $this->FormatPlaceOfLoading(),
            'port_of_discharge' => $this->FormatPortOfDischarge(),
            // 'final_destination' => empty($this->bl->delivery_agent_id)?$this->bl->final_destination:($this->bl->delivery_agent->name .', '. $this->bl->delivery_agent->city->name.', '. $this->bl->delivery_agent->country->name),
            'final_destination' => $this->bl->final_destination,

            'office' => !empty($this->bl->office_id)?$this->bl->office:null,

            'shipper' => $this->formatCompanyData($this->bl->shipper, $this->bl->shipper_text),
            'consignee' => $this->formatCompanyData($this->bl->consignee, $this->bl->consignee_text),
            'notify_party' => $this->formatCompanyData($this->bl->notify_party, $this->bl->notify_party_text),
            'notify_party2' => $this->formatCompanyData($this->bl->notify_party2, $this->bl->notify_party2_text),
            
            // 'delivery_agent' => $this->bl->delivery_agent??$this->bl->delivery_agent_manual,
            'delivery_agent' => $this->formatCompanyData($this->bl->delivery_agent, $this->bl->delivery_agent_manual),

            'marks' => $this->bl->marks,
            
            'qty' => $this->bl->qty,
            'weight' => $this->bl->weight,
            'net_weight' => $this->bl->net_weight,
            'measurement' => $this->bl->measurement,

            'discription_of_goods' => $this->bl->discription_of_goods,
            
            'freight_type' => $this->bl->freight_type,
            'freight_and_charges' => $this->bl->freight_and_charges,
            'revenue_tons' => $this->bl->revenue_tons,
            'rate' => $this->bl->rate,
            'prepaid' => $this->bl->prepaid,
            'collect' => $this->bl->collect,
            'ex_rate' => $this->bl->ex_rate,
            'prepaid2' => $this->bl->prepaid2,
            'payable_at' => $this->bl->payable_at,
            'place_issue' => $this->bl->place_issue,

            'original_text' => $this->bl->original_text,

            'bl_containers' => $this->bl->bl_containers,
            'container_count' => count($this->bl->bl_containers),
            'show_no_of_container_on_bl' => !empty($this->bl->marks)&&!empty($this->bl->notify_party2)?2:(!empty($this->bl->marks)||!empty($this->bl->notify_party2)?3:5),
            'container_tues' => BLHelper::tues($this->bl->bl_containers),
            
            'issue_date' => $this->formatDateData($this->bl->issue_date), //d/m/Y
            'shipped_on_board' => $this->formatDateData($this->bl->shipped_on_board),
            'rcv_for_shipment' => $this->formatDateData($this->bl->rcv_for_shipment),
            'locked' => $this->bl->locked,
            'is_final' => $this->bl->is_final,
        ];
    }

    private function getSpellout($number=0, $lang='en') : string {
        return (new NumberFormatter($lang, NumberFormatter::SPELLOUT))->format($number);
    }

    private function formatDateData($date) : string|null {
        return !empty($date)?Carbon::parse($date)->format($this->getDateFormat()):null;
    }

    private function FormatPlaceOfLoading() : string|null {
        return !empty($this->bl->place_of_loading_manual) || empty($this->bl->place_of_loading_id)?
            $this->bl->place_of_loading_manual:
            ($this->bl->place_of_loading->name .', '. $this->bl->place_of_loading->country_name);
    }

    private function FormatPortOfDischarge() : string|null {
        return !empty($this->bl->port_of_discharge_manual) || empty($this->bl->port_of_discharge_id)?
            $this->bl->port_of_discharge_manual:
            ($this->bl->port_of_discharge->name .', '. $this->bl->port_of_discharge->country_name);
    }

    private function formatCompanyData($data, $optional_field=null) : string|null {
        return empty($data)?
            $optional_field:
            (
                $data->name .", \n". 
                $data->address .", \n". 
                $data->city->name ." - ". 
                $data->post_code .", ". 
                $data->country->name .", \n". 
                "Email: " . $data->primary_email .", ". 
                "Tel: " . $data->tel
            );
    }

    private function formatVesselData($vessel, $old_data=null) : string|null {
        return (empty($vessel))?$old_data:$vessel->name;
    }

    private function formatVoyageData($voyage, $old_data=null) : string|null {
        // dd($voyage, $old_data);
        return (empty($voyage))?$old_data:$voyage->voy_no;
    }
}
