<?php

namespace App\Tables\Columns;

use Filament\Tables\Columns\Column;
use Illuminate\Database\Eloquent\Model;

class NextVoyage extends Column
{
    protected string $view = 'tables.columns.next-voyage';

    function next_voyage($port_name = false) : string|array {
        $sc = [];
        
        foreach ($this->record->schedules as $schedule) {
            $transit = $schedule->transits->first();
            $vessel = $schedule->vessel->name . ' (' . $schedule->vessel->code . ')';
            
            $port = '';
            if (!empty($transit)) {
                $port = $transit->port_of_loading->iso;
            }
            if (!empty($transit) && $port_name) {
                $port = $transit->port_of_loading->name . ' (' . $transit->port_of_loading->iso . ')';
            }
            $sc[] = [$transit->eta, $port, $vessel];
        }
        return $sc;
    }
}
