<?php

namespace App\Traits;

final class BLHelper
{
    public static function tues($bl_containers) : string {
        $tues_count = 0;
        if (count($bl_containers) > 0) {
            foreach ($bl_containers as $container) {
                $tues_count += $container->container_size->getTue();
            }
        }
        return $tues_count . ($tues_count>1?' Tues':' Tue');
    }

    public static function container_list($bl_containers, $with = ['size']) : string {
        $list = '';
        if (!empty($bl_containers)) {
            $list .= $bl_containers->container_num;
            $list .= in_array('size', $with)?'(' . $bl_containers->container_size->getLabel() . ')':'';
        }
        return $list;
    }

    public static function getIcon($locked=true, $final=false) : string {
        if ($final) {
            return self::getFinalIcon();
        }
        if ($locked) {
            return self::getLockedIcon();
        }
        return '';
    }

    public static function getFinalIcon() : string {
        return 'heroicon-o-check-badge';
    }

    public static function getLockedIcon() : string {
        return 'heroicon-o-lock-closed';
    }

    public static function getColor($locked=true, $final=false) : string {
        if ($final) {
            return 'green';
        }
        if ($locked) {
            return 'gray';
        }
        return '';
    }
}
