<?php

namespace App\Traits;

use Carbon\Carbon;

trait FilterableByDates
{
    public $date_filterable_column = 'created_at';

    public function scopeToday($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereDate($column, Carbon::today());
    }

    public function scopeFromToday($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereDate($column, '>=', Carbon::today());
    }

    public function scopeYesterday($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereDate($column, Carbon::yesterday());
    }

    public function scopeMonthToDate($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereBetween($column, [Carbon::now()->startOfMonth(), Carbon::now()]);
    }

    public function scopeQuarterToDate($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        $now = Carbon::now();
        return $query->whereBetween($column, [$now->startOfQuarter(), $now]);
    }

    public function scopeYearToDate($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereBetween($column, [Carbon::now()->startOfYear(), Carbon::now()]);
    }

    public function scopeLast7Days($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereBetween($column, [Carbon::today()->subDays(6), Carbon::now()]);
    }

    public function scopeLast30Days($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereBetween($column, [Carbon::today()->subDays(29), Carbon::now()]);
    }

    public function scopeLastQuarter($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        $now = Carbon::now();
        return $query->whereBetween($column, [$now->startOfQuarter()->subMonths(3), $now->startOfQuarter()]);
    }

    public function scopeLastYear($query, $column = '')
    {
        $column = $column?:$this->date_filterable_column;
        return $query->whereBetween($column, [Carbon::now()->subYear(), Carbon::now()]);
    }
}