<?php

namespace App\Traits;
use App\Models\BL;
use App\Models\Port;
use App\Models\BLPrefix;

trait HasBLNumber
{
    protected $pol;
    protected $pod;

    protected string $company_prefix = 'SLH';

    public function generate($pol, $pod) : string {
        $last_number = $this->getLastNumber($pol, $pod);
        $next_number = $this->getNextNumber($last_number);
        $bl_number = $this->ensureNotExist($next_number, $pol, $pod);

        return $this->format($bl_number, $pol, $pod);
    }

    public function format(int $number, $pol, $pod) : string {
        $pol_code = $this->getPortCode($pol);
        $pod_code = $this->getPortCode($pod);
        return $this->company_prefix . strtoupper($pol_code) . strtoupper($pod_code) .sprintf('%05d', $number);
    }

    public function convertToData($bl_number) : array {
        $convert = str_split($bl_number, 3);
        $number = (string) $convert[3]. (string) $convert[4];
        return [
            'company_prefix' => $convert[0],
            'pol_code' => $convert[1],
            'pod_code' => $convert[2],
            'number' => $number
        ];
    }

    public function isExist(int $number, $pol, $pod) : bool {
        $formatted_number = $this->format($number, $pol, $pod);
        $find_bl = BL::where('bl_no', $formatted_number)->withoutGlobalScopes(['office', 'organization'])->first();
        return !empty($find_bl);
    }

    public function ensureNotExist(int $number, $pol, $pod) : int {
        while ($this->isExist($number, $pol, $pod)) {
            $number++;
        }
        return $number;
    }

    function getPortCode(int $id) : string|null {
        $port = Port::find($id);
        return $port?->iso;
    }

    public function getLastNumber($pol, $pod) : int {
        $last_number = BLPrefix::where('pol_id', $pol)->where('pod_id', $pod)->first();
        // dd(empty($last_number)?1:$last_number->last_number);
        return empty($last_number)?0:$last_number->last_number;
    }

    public function getNextNumber(int $number, int $increment_by = 1) : int {
        return $number+$increment_by;
    }

    public function updateLastNumber($bl_number, $pol, $pod) : void {
        $number = $this->convertToData($bl_number);
        $prefix = (string)($number['pol_code'].$number['pod_code']);

        BLPrefix::updateOrCreate(
            ['pol_id' => $pol, 'pod_id' => $pod, 'prefix' => $prefix],
            ['last_number' => (int)$number['number']]
        );
    }
}
