<?php

namespace Database\Factories;

use App\Enums\ContainerSizes;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\BLContainer>
 */
class BLContainerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'bl_id' => rand(1, 20),
            'container_num' => fake()->regexify('[A-Z]{5}[0-4]{3}').rand(111111, 999999),
            'container_size' => fake()->randomElement(ContainerSizes::cases()),
            'seal_no' => fake()->regexify('[A-Z]{5}[0-4]{3}'),
            'pack_qty' => rand(20, 30).' Pallets',
            'gross_weight' => rand(11111.00,99999.99),
            'net_weight' => rand(11111.00,99999.99),
            'measurement' => rand(24.00,29.00),
            'vgm' => rand(11111.00,99999.99),
        ];
    }
}
