<?php

namespace Database\Factories;

use App\Enums\CompanyTypes;
use Illuminate\Support\Arr;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Company>
 */
class CompanyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->company(),
            'code' => fake()->regexify('[A-Z]{5}[0-4]{3}'),
            'type' => Arr::random(CompanyTypes::cases()),
            'address' => fake()->streetAddress(),
            'city_id' => rand(1, 100),
            'state_id' => rand(1, 100),
            'country_id' => rand(1, 100),
            'post_code' => fake()->postcode(),
            'website' => 'example.com',
            'primary_email' => fake()->email(),
            'tel' => fake()->phoneNumber(),
            'mobile' => fake()->phoneNumberWithExtension(),
            // 'comapany_admin' => rand(1, 100),
            // 'business_id' => rand(1, 100),
            'organization_id' => rand(1,5),
            'note' => fake()->text(),
        ];
    }
}
