<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Organization>
 */
class OrganizationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->company(),
            'code' => fake()->regexify('[A-Z]{5}[0-4]{3}'),
            'address' => fake()->streetAddress(),
            'city_id' => rand(1, 100),
            'state_id' => rand(1, 100),
            'country_id' => rand(1, 100),
            'post_code' => fake()->postcode(),
            'website' => 'example.com',
            'email' => fake()->email(),
            'tel' => fake()->phoneNumber(),
            'mobile' => fake()->phoneNumberWithExtension(),
            'note' => fake()->text(),
            'date_format' => rand(1,9),
            'time_format' => rand(1,2),
            'currency_id' => rand(1,100),
            'vat_number' => fake()->regexify('[A-Z]{5}[0-4]{3}').rand(111111, 999999),
            'office_id' => rand(1,10),
        ];
    }
}
