<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ScheduleTransit>
 */
class ScheduleTransitFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $days = rand(1, 30);
        $etb_days = $days + rand(1, 3);
        $etd_days = $days + rand(4, 7);
        return [
            'schedule_id' => rand(1, 100),
            'port_of_loading_id' => rand(1, 856),
            
            'eta' => date("Y-m-d H:i:s", strtotime("+".$days." days")), // 1995-01-05 00:00:00
            'etb' => date("Y-m-d H:i:s", strtotime("+".$etb_days." days")),
            'etd' => date("Y-m-d H:i:s", strtotime("+".$etd_days." days")),

            'cut_off_date' => date("Y-m-d", strtotime("+".$days." days")),
            'cut_off_time' => date("H:i:s", mt_rand(1262055681,1262055681)),
            
            'string' => fake()->randomElement(['SCS', 'MCS']) . ' STRING: ' . rand(0, 9),
            'reg_no' =>  fake()->bothify('####') . '/' . fake()->bothify('####'),
            'active' => rand(0, 1),
        ];
    }
}
