<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ServiceRoute>
 */
class ServiceRouteFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $sub_regions = [
            'Caribbean',
            'Central America',
            'North America',
            'South America',
            'Central Asia',
            'East Asia',
            'South Asia',
            'South East Asia',
            'Central Europe',
            'Eastern Europe',
            'Nordic countries',
            'Southern Europe',
            'Western Europe',
            'Middle East',
            'North Africa',
            'Australia',
            'New Zealand',
            'Pacific Islands',
            'Central Africa',
            'East Africa',
            'Southern Africa',
            'West Africa',
        ];
        return [
            'name' => fake()->randomElement($sub_regions) . ' to ' . fake()->randomElement($sub_regions),
            'port_of_loading_id' => rand(1, 856),
            'port_of_discharge_id' => rand(1, 856),
            'active' => rand(0, 1),
        ];
    }
}
