<?php

namespace Database\Factories;

use App\Enums\ContainerSizes;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SlotBooking>
 */
class SlotBookingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'schedule_id' => rand(1, 100),
            'con_size' => fake()->randomElement(ContainerSizes::cases()),
            'requested_tues' => rand(1, 100),
            'booked_tues' => rand(1, 100),
            'loaded_tues' => rand(1, 100),
            'cost_per_tue' => rand(1.00, 999.99),
            'approx_selling_price' => rand(1.00, 999.99),
        ];
    }
}
