<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Vessel>
 */
class VesselFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->unique()->firstName() . ' ' . fake()->cityPrefix();
        $words = explode(" ", $name);
        $code = '';
        foreach($words as $word){
            $code .= $word[0].$word[rand(1,2)];
        }
        
        return [
            // 'name' => fake()->name(),
            'name' => fake()->randomElement(['MV ', 'MT ']) . $name,
            'code' => strtoupper($code . fake()->randomLetter()),
            'route_start' => rand(1, 856),
            'route_end' => rand(1, 856),
            'capacity' => rand(999, 99999),
        ];
    }
}
