<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_routes', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->foreignId('port_of_loading_id')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('port_of_discharge_id')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            // $table->json('connecting_ports')->nullable();
            $table->tinyInteger('active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_routes');
    }
};
