<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_ports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_route_id')->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignId('port_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            // $table->morphs('serviceable');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_ports');
    }
};
