<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_transits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('schedule_id')->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignId('port_of_loading_id')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();

            $table->timestamp('eta')->nullable()->default(\Carbon\Carbon::now()->addDays(3));
            $table->timestamp('etb')->nullable()->default(\Carbon\Carbon::now()->addDays(4));
            $table->timestamp('etd')->nullable()->default(\Carbon\Carbon::now()->addDays(7));

            $table->date('cut_off_date')->nullable();
            $table->time('cut_off_time')->nullable();
            $table->string('string')->nullable();
            $table->string('reg_no')->nullable();
            $table->tinyInteger('active')->default(1);
            
            $table->integer('sort')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_transits');
    }
};
