<div class="filament-hidden">

![header](./.github/resources/pxlrbt-activity-log.png)
    
</div>

# Filament Activity Log

[![Latest Version on Packagist](https://img.shields.io/packagist/v/pxlrbt/filament-activity-log.svg?include_prereleases)](https://packagist.org/packages/pxlrbt/filament-activity-log)
[![Software License](https://img.shields.io/badge/license-MIT-brightgreen.svg)](LICENSE.md)
![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/pxlrbt/filament-activity-log/code-style.yml?branch=main&label=Code%20style&style=flat-square)
[![Total Downloads](https://img.shields.io/packagist/dt/pxlrbt/filament-activity-log.svg)](https://packagist.org/packages/pxlrbt/filament-activity-log)


This package adds a page to the Filament Admin panel to view the activity log generated by [`spatie/laravel-activitylog`](https://github.com/spatie/laravel-activitylog).

<div class="filament-hidden">
    
![Screenshot](./.github/resources/screenshot.png)

</div>

## Installation

| Plugin Version | Filament Version | PHP Version |
|----------------|-----------------|-------------|
| 0.1.x            | 2.x   | \> 8.0      |
| 1.x            | 3.x             | \> 8.1      |

Install via Composer.

**Requires PHP 8.0 and Filament 2.0**

```bash
composer require pxlrbt/filament-activity-log
```

> **Warning**
> This plugin only offers a page to show activities related to your model. You need [`spatie/laravel-activitylog`](https://github.com/spatie/laravel-activitylog) installed and configured for it to work. It is important you are using the `LogsActivity` trait as per [Spatie's docs](https://spatie.be/docs/laravel-activitylog/v4/advanced-usage/logging-model-events) for this work as we use the '->activities()' method of the trait.

## Usage

Make sure you use a **custom theme** and the vendor folder for this plugins is published, so that it includes the Tailwind CSS classes.

### Create a page

Create the page inside your resources `Pages/` directory. Replace `UserResource` with your resource. 

```php
<?php

namespace App\Filament\Resources\UserResource\Pages;

use pxlrbt\FilamentActivityLog\Pages\ListActivities;

class ListUserActivities extends ListActivities
{
    protected static string $resource = UserResource::class;
}
```

### Register the page

Add the page to your resource's `getPages()` method.

```php
public static function getPages(): array
{
    return [
        'index' => Pages\ListUsers::route('/'),
        'create' => Pages\CreateUser::route('/create'),
        'activities' => Pages\ListUserActivities::route('/{record}/activities'),
        'edit' => Pages\EditUser::route('/{record}/edit'),
    ];
}
```

### Link to your page

Use a Filament action to link to your from your table or page.

```php
$table->actions([
    Action::make('activities')->url(fn ($record) => YourResource::getUrl('activities', ['record' => $record]))
]);
```

## Contributing

If you want to contribute to this packages, you may want to test it in a real Filament project:

- Fork this repository to your GitHub account.
- Create a Filament app locally.
- Clone your fork in your Filament app's root directory.
- In the `/filament-activity-log` directory, create a branch for your fix, e.g. `fix/error-message`.

Install the packages in your app's `composer.json`:

```json
"require": {
    "pxlrbt/filament-activity-log": "dev-fix/error-message as main-dev",
},
"repositories": [
    {
        "type": "path",
        "url": "filament-activity-log"
    }
]
```

Now, run `composer update`.
