<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title>BILL OF LANDING</title>
        <link rel="stylesheet" href="{{asset('css/bl/pdf-low-res.css')}}">
    
        @php
            $bl_bg = 'background: url('. resource_path('no-image.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
            $left = 0;
            if ($bg) {
                $bl_bg = 'background: url('. resource_path('images/bl/bl-front-low-res.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
                $left = -40;
            }
        @endphp
    
        <style>
            body {
                font-family: Consolas, Menlo, Monaco, "Lucida Console", "Liberation Mono", "DejaVu Sans Mono", "Bitstream Vera Sans Mono", "Courier New", monospace, serif;
                line-height: 11px;
                font-size: 11px;
                min-height: 1080px;
                color: #555555;
            }
            #watermark {
                position: fixed;
                font-size: 140px;
                font-weight: bold;
                top: 45%;
                width: 100%;
                text-align: center;
                opacity: .1;
                transform: rotate(-45deg);
                transform-origin: 50% 50%;
                z-index: 0;
            }
            .page-break {
                page-break-after: always;
            }
            .c1 {
                left: 45px;
            }
            .c3 {
                left: 205px;
            }
            .c4 {
                left: 268px;
            }
            .c5 {
                left: 340px;
            }
            .c5.payable_at {
                left: 350px;
            }
            .c6 {
                left: 380px;
            }
            .c7 {
                left: 440px;
            }
            .c8 {
                left: 515px;
            }
            .c9 {
                left: 605px;
            }
            .c10 {
                left: 645px;
            }
            .c11 {
                left: 690px;
            }
            .row1 {
                top: 85px;
            }
            .row2 {
                top: 175px;
            }
            .row3 {
                top: 265px;
            }
            .row4 {
                top: 310px;
            }
            .row5 {
                top: 357px;
            }
            .row6 {
                top: 397px;
            }
            .row7 {
                top: 435px;
            }
            .row8 {
                top: 485px;
            }
            .row10 {
                top: 815px;
            }
            .row11 {
                top: 970px;
            }
            .row12 {
                top: 1065px;
            }
        </style>
    </head>
    <body>
        @php
        // dd($data);
        $info = $bl??(!empty($data)?$data[0]:false);
        // dd($info);
    
        // dd($info->delivery_agent);
    
        // dd($bl_containers = $info->bl_containers);
        $bl_containers = $info->bl_containers;
        // dd(count($bl_containers))
        $qty_container = count($bl_containers);
    
        $show_cont_on_bl = !empty($info->marks)&&!empty($info->notify_party2)?2:(!empty($info->marks)||!empty($info->notify_party2)?3:5);
        
    
        $shipper_line_1 = $info->shipper;
        $shipper_remaining = null;
        if(strpos( $info->shipper, "\n" )) list($shipper_line_1, $shipper_remaining) = explode("\n", $info->shipper, 2);
    
        $consignee_line_1 = $info->consignee;
        $consignee_remaining = null;
        if(strpos( $info->consignee, "\n" )) list($consignee_line_1, $consignee_remaining) = explode("\n", $info->consignee, 2);
    
        $notify_party_line_1 = $info->notify_party;
        $notify_party_remaining = null;
        if(strpos( $info->notify_party, "\n" )) list($notify_party_line_1, $notify_party_remaining) = explode("\n", $info->notify_party, 2);
        
        $notify_party2_line_1 = $info->notify_party2;
        $notify_party2_remaining = null;
        if (!empty($info->notify_party2)) {
            // list($notify_party2_line_1, $notify_party2_remaining) = explode("\n", $info->notify_party2, 2);
            if(strpos( $info->notify_party2, "\n" )) list($notify_party2_line_1, $notify_party2_remaining) = explode("\n", $info->notify_party2, 2);
    
            $notify_party_remaining .= ' *';
        }
    
        $issue_date = $info->issue_date??($info->is_final?$info->eta:'');
        $shipped_on_board = $info->shipped_on_board??($info->is_final?$info->eta:'');
    
        // dd($notify_party_line_1, $notify_party_remaining);
        @endphp
    
        @if (!$info->is_final)
            <div id="watermark">
                DRAFT B/L
            </div>
        @endif
    
        <div id="content2">
            <div class="page_1 bl page" style="{!! $bl_bg !!}">
                <div class="shipper row1 c1">
                    <div>{{ $shipper_line_1 }}</div>
                    <div>{!! nl2br($shipper_remaining) !!}</div>
                </div>
    
                <div class="consignee row2 c1">
                    <div>{{ $consignee_line_1 }}</div>
                    <div>{!! nl2br($consignee_remaining) !!}</div>
                </div>
    
                <div class="notify_party row3 c1">
                    <div>{{ $notify_party_line_1 }}</div>
                    <div>{!! nl2br($notify_party_remaining) !!}</div>
                </div>
                <div class="delivery_agent row4 c7">
                    @if (empty($info->delivery_agent_manual) && !empty($info->delivery_agent))
                        <div>{{ $info->delivery_agent->name }}</div>
                        <div>{{ $info->delivery_agent->address }}, {{ $info->delivery_agent->city->name }} - {{ $info->delivery_agent->post_code }}, {{ $info->delivery_agent->country->name }}</div>
                        <div>Tel: {{ $info->delivery_agent->tel }}
                            @if (!empty($info->delivery_agent->mobile))
                            , {{ $info->delivery_agent->mobile }}
                            @endif
                        </div>
                        @if (!empty($info->delivery_agent->primary_email))
                        <div>
                            Email: {{ $info->delivery_agent->primary_email }}
                        </div>
                        @endif
                    @else
                        <div>{!! nl2br($info->delivery_agent_manual) !!}</div>
                    @endif
                </div>
    
                <!--Row 5-->
                <div class="pre_carriage_vessel row5 c1">{{ $info->pre_carriage_vessel }}&nbsp;</div>
                {{-- <div class="voy_no row5 c3">{{ $info->voy_no }}&nbsp;</div> --}}
                <div class="voy_no row5 c3">{{ $info->voy_no_pre_carriage }}&nbsp;</div>
                <div class="place_of_receipt row5 c4">{{ $info->place_of_receipt }}</div>
    
                <!--Row 6-->
                <div class="ocean_vessel row6 c1">{{ $info->ocean_vessel }}</div>
                <div class="voy_no_destination row6 c3">{{ $info->voy_no_destination }}</div>
    
                @if (!empty($info->place_of_loading_id))
                <div class="place_of_loading row6 c4">{{ $info->place_of_loading->name }}, {{ $info->place_of_loading->country->name }}</div>
                @else
                <div class="place_of_loading row6 c4">{{ $info->place_of_loading_manual }}</div>
                @endif
    
                <div class="booking_ref_no row6 c7">{{ $info->booking_ref_no }}</div>
                <div class="bl_no row6 c9"><strong>{{ $info->bl_no }}</strong></div>
    
                <!--Row 7-->
                @if (!empty($info->port_of_discharge_id))
                <div class="port_of_discharge row7 c1">{{ $info->port_of_discharge->name }}, {{ $info->port_of_discharge->country->name }}</div>
                @else
                <div class="port_of_discharge row7 c1">{{ $info->port_of_discharge_manual }}</div>
                @endif
                
                <div class="final_destination row7 c4">{{ $info->final_destination }}</div>
                <div class="shipper_ref row7 c7">{{ $info->shipper_ref }}</div>
                @php
                    $org_bl_spellout = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                @endphp
                <div class="original_bl row7 c9">{{ $info->original_bl }} ({{$org_bl_spellout->format($info->original_bl)}})</div>
    
                        {{-- @dd(count($bl_containers)) --}}
                <!--Row 8-->
                <div class="container_info row8 c1">
                    {{-- <strong>CONTAINER / SEAL NO</strong><br> --}}
                    @if (count($bl_containers) > $show_cont_on_bl)
                        <div class="as_per_rider">
                            <strong>Container Info:</strong> AS PER RIDER
                        </div>
                    @else
                        @php
                            $container_count = [];
                        @endphp
                        @foreach ($bl_containers as $container)
                            @php
                                $container_count[$container->container_size->value] = $container_count[$container->container_size->value]??0;
                                $container_count[$container->container_size->value]++;
    
                                $con_additional_info = '/ ' . ($container->gross_weight??'') . ' / ' . ($container->measurement??'') . ' / ' . ($container->vgm??'');
                            @endphp
                            <div class="container_list">
                                <strong>{{ $container->container_num }}({{ $container->container_size->getLabel() }}) / {{ $container->seal_no }}</strong>
                                @if (!empty($container->pack_qty))
                                    <br>
                                    <span>{{ $container->pack_qty }} {{ $con_additional_info }}</span>
                                @endif
                            </div>
                        @endforeach
                    @endif
                    
                    @if (!empty($info->marks))
                        <div class="marks">
                            {!! nl2br($info->marks) !!}
                        </div>
                    @endif
    
                    @if (!empty($info->notify_party2))
                        <div class="notify_party2">
                            <div>* {{ $notify_party2_line_1 }}</div>
                            <div>{{ $notify_party2_remaining }}</div>
                        </div>
                    @endif
                </div>
    
                {{-- <div class="qty row8 c4"><strong>{{ $qty_container }}</strong></div> --}}
                <div class="qty row8 c4">
                    {{ $info->qty }}
                    <div class="mt-40"></div>
                    @if (!empty($info->cargo_type))
                    <div class="cargo_type mt-10">
                        {{-- <div class="underline">cargo_type</div> --}}
                        {{ $info->cargo_type->getLabel() }}
                    </div>
                    @endif
    
                    @if (!empty($info->loading_type))
                    <div class="loading_type mt-10">
                        {{-- <div class="underline">loading_type</div> --}}
                        {{ $info->loading_type->getLabel() }}
                    </div>
                    @endif
                </div>
                <div class="discription_of_goods row8 c5">
                    {{-- <textarea readonly rows="35" cols="32" style="border:0;">{!! $info->discription_of_goods !!}</textarea> --}}
                    <div><strong>SHIPPER'S LOAD, COUNT AND SEALED</strong></div>
                    {!! nl2br($info->discription_of_goods) !!}
                </div>
                <div class="weight row8 c9">
                    {{ $info->weight }}
                    @if (!empty($info->net_weight))
                    <div class="net_weight">
                        <div class="underline">NET WT</div>
                        {{ $info->net_weight }}
                    </div>
                    @endif
                </div>
                <div class="measurement row8 c11">{{ $info->measurement }}</div>
    
                <!--Row 9-->
                {{-- <div class="container_no row9 c1">
                    <table>
                        <tr>
                            <td>CONTAINER NO</td><td>C.SIZE</td><td>SEAL NO</td>
                        </tr>
                        @foreach ($bl_containers as $container)
                        <tr>
                            <td>{{ $container->container->container_no }}</td>
                            <td>{{ $container->container->size }}</td>
                            <td>{{ $container->seal_no }}</td>
                        </tr>
                        @endforeach
                    </table>
                </div> --}}
    
                <!--Row 10-->
                <div class="freight_info row10 c1">
                    <div><strong>FREIGHT {{ $info->freight_type }}</strong></div>
                    <?php 
                    // $fc = htmlspecialchars_decode($info->freight_and_charges);
                    // $fc = html_entity_decode($fc);
                    ?>  
                    {{-- <div><textarea readonly rows="15" cols="30" style="border:0; font-size:9px;">{!! $fc !!}</textarea></div> --}}
                    {!! $info->freight_and_charges !!}
                </div>
                <div class="revenue_tons row10 c4">{{ $info->revenue_tons }}</div>
                <div class="rate row10 c6">{{ $info->rate }}</div>
                <div class="prepaid row10 c8">{{ $info->prepaid }}</div>
                <div class="collect row10 c10">{{ $info->collect }}</div>
    
                <!--Row 11-->
                <div class="ex_rate row11 c1">{{ $info->ex_rate }}</div>
                <div class="prepaid2 row11 c3">{{ $info->prepaid2 }}</div>
                <div class="payable_at row11 c5">{{ $info->payable_at }}</div>
                <div class="place_issue row11 c8">{{ $info->place_issue }} {{ !empty($issue_date)?date("d/m/Y", strtotime($issue_date)):'' }}</div>
                {{-- <div class="place_issue row11 c8"><strong>{{ $info->place_issue }} {{ !empty($info->issue_date)?date("d/m/Y", strtotime($info->issue_date)):'' }}</strong></div> --}}
                <div class="shipped_on_board row12 c1"><strong>{{ !empty($shipped_on_board)?date("d/m/Y", strtotime($shipped_on_board)):'' }}</strong></div>
                {{-- <div class="shipped_on_board row12 c1"><strong>{{ !empty($info->shipped_on_board)?date("d/m/Y", strtotime($info->shipped_on_board)):'' }}</strong></div> --}}
            </div>
        </div>
    </body>
</html>