<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Ridersheet #{{ $bl->bl_no }}</title>
    <style>
        @page {
            margin: 0cm 0cm;
            margin-top: 180px;
            margin-bottom: 80px;
        }
        header {
            position: fixed;
            top: -160px;
            left: 0px;
            right: 0px;
            height: 160px;
            color: black;
            text-align: center;
            z-index: 0;
            padding: 10px 40px;
            box-sizing: border-box;
            background-image: url({{ resource_path($logo) }});
            background-repeat: no-repeat;
            background-position: 93% top;
        }
        footer {
            position: fixed;
            bottom: -80px;
            left: 0px;
            right: 0px;
            height: 60px;
            color: black;
            text-align: right;
            padding: 10px 48px;
            box-sizing: border-box;
        }
        footer .pagenum:before {
            content: counter(page);
        }
        footer .company {
            text-transform: capitalize;
            font-family: 'Roboto';
        }
        footer span.company_name {
            color: #293a9b;
            font-weight: bold;
        }
        .rider_sheet {
            /* margin-top: 180px; */
            /* margin-bottom: 180px; */
        }
        
        body {
            display: block;
            padding: 0 40px;
            text-justify: inter-word;
            font-family: Consolas, Menlo, Monaco, "Lucida Console", "Liberation Mono", "DejaVu Sans Mono", "Bitstream Vera Sans Mono", "Courier New", monospace, serif;
            line-height: 11px;
            font-size: 11px;
            min-height: 1080px;
            color: #555555;
            text-transform: uppercase;
        }
        
        .title {
            text-align: center;
            font-size: 24px;
            margin-bottom: 10px;
        }

        .sub_title {
            font-size: 12px;
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        tr {
            border: 1px solid #999999;
        }

        table thead {
            background-color: #333333;
            color: white;
        }

        td {
            border: none;
            font-weight: bold;
            padding: 5px;
        }

        h3 {
            margin-top: 30px;
        }
    </style>
</head>
<body>
    <header>
        <div class="content">
            <h3 class="title">Rider Sheet</h3>
            <div class="sub_title">
                <strong>ATTACHED SHEET OF BL# {{ $bl->bl_no }}</strong>
            </div>
            <table width="100%">
                <tr>
                    <td width="30%">Bill of Lading No</td>
                    <td> : </td>
                    <td width="67%">{{ $bl->bl_no }}</td>
                </tr>
                <tr>
                    <td width="30%">Vessel Name</td>
                    <td> : </td>
                    <td width="67%">
                        @php
                            $vessel_name = !empty($bl->ocean_vessel)?$bl->ocean_vessel->name:$bl->ocean_vessel_old;
                            $voyage = !empty($bl->ocean_vessel_voy)?$bl->ocean_vessel_voy->voy_no:$bl->voy_no_destination_old;
                        @endphp
                        {{ !empty($vessel_name)?($vessel_name . ' '. $voyage ):(!empty($bl->pre_carriage_vessel)?$bl->pre_carriage_vessel:'No vessel selected') }}
                    </td>
                </tr>
            </table>
        </div>
    </header>

    <footer>
        <div class="pagenum-container">Page <span class="pagenum"></span></div>
        <div class="company">Signed for the carrier <span class="company_name">{{ $registered_company_name }}</span></div>
    </footer>

    <div class="rider_sheet">
        @if (count($bl->bl_containers) > 0)
        <table width="100%">
            <thead>
                <tr>
                    <td>Container</td>
                    <td>Seal No.</td>
                    <td>Size</td>
                    <td>Num. Of Pkgs</td>
                    <td>Gross Weight (KG)</td>
                    <td>Net Weight (KG)</td>
                    <td>Measurement (M3)</td>
                    <td>VGM (KG)</td>
                </tr>
            </thead>
            <tbody>
            @foreach ($bl->bl_containers as $container)
                <tr>
                    <td>{{ $container->container_num }}</td>
                    <td>{{ $container->seal_no }}</td>
                    <td>{{ $container->container_size->getLabel() }}</td>
                    <td>{{ $container->pack_qty }}</td>
                    <td>{{ !empty($container->gross_weight)?$container->gross_weight.$bl->units['weight']:'' }}</td>
                    <td>{{ !empty($container->net_weight)?$container->net_weight.$bl->units['weight']:'' }}</td>
                    <td>{{ !empty($container->measurement)?$container->measurement.$bl->units['measurement']:'' }}</td>
                    <td>{{ $container->vgm }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
        @endif
        
        <div class="rider_sheet_content">
            @php
                // dd($container_count);
            @endphp
            @if (!empty($bl->rider_sheet))
                <h3>Description</h3>
            @endif
            {!! nl2br($bl->rider_sheet) !!}
        </div>
    </div>
</body>
</html>