<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum CompanyTypes: string implements HasLabel, HasColor, HasIcon
{
    case BRANCH = 'branch';
    case WAREHOUSE = 'warehouse';
    case DEPOT = 'depot';
    case AGENT = 'agent';
    case CUSTOMER = 'customer';
    case BANK = 'bank';
    case OPERATOR = 'operator';
    case CNF = 'CNF';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::BRANCH => 'Branch',
            self::WAREHOUSE => 'Warehouse',
            self::DEPOT => 'Depot',
            self::AGENT => 'Agent',
            self::CUSTOMER => 'Customer',
            self::BANK => 'Bank',
            self::OPERATOR => 'Vessel Operator',
            self::CNF => 'CNF',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::BRANCH => 'secondary',
            self::WAREHOUSE => 'gray',
            self::DEPOT => 'info',
            self::AGENT => 'agent',
            self::CUSTOMER => 'success',
            self::BANK => 'danger',
            self::OPERATOR => 'secondary',
            self::CNF => 'warning',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::BRANCH => 'heroicon-o-building-office-2',
            self::WAREHOUSE => 'heroicon-o-home-modern',
            self::DEPOT => 'heroicon-o-building-storefront',
            self::AGENT => 'heroicon-o-building-office',
            self::CUSTOMER => "heroicon-o-briefcase",
            self::BANK => "heroicon-o-building-library",
            self::OPERATOR => 'heroicon-o-home-modern',
            self::CNF => "heroicon-o-document-text",
        };
    }
}