<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Bl_container extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function bl(): BelongsTo
    {
        return $this->belongsTo(Billoflading::class, 'bl_id', 'id');
    }

    /**
     * Get the container that owns the Bl_container
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function container(): BelongsTo
    {
        return $this->belongsTo(Container::class);
    }
}
