<?php

namespace Database\Factories;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use App\Enums\ContainerSizes;
use App\Enums\ContainerTypes;
use App\Enums\ContainerPropertyTypes;
use App\Enums\ContainerStatuses;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Container>
 */
class ContainerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'container_no' => fake()->regexify('[A-Z]{5}[0-4]{3}').rand(111111, 999999),
            'size' => Arr::random(ContainerSizes::cases()),
            'type' => Arr::random(ContainerTypes::cases()),
            'status' => Arr::random(ContainerStatuses::cases()),
            'property_type' => Arr::random(ContainerPropertyTypes::cases()),
            'free_days' => Arr::random([15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 120]),
            'available' => fake()->boolean(),
            'last_updated_by' => rand(1, 100),
            'added_by' => rand(1, 100),
            'deleted_by' => rand(1, 100),
        ];
    }
}
