<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Enums\Statuses;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        \App\Models\OfficeUser::factory()->create([
            'name' => 'Kawsar',
            'email' => 'kawsar@sealloyd.com',
        ]);
        // \App\Models\User::factory()->create([
        //     'name' => 'Kawsar',
        //     'email' => 'kawsar@sealloyd.com',
        // ]);
        $this->command->info('User Kawsar (kawsar@sealloyd.com) has been created.');

        \App\Models\OfficeUser::factory()->create([
            'name' => 'Admin',
            'email' => 'admin@admin.com',
        ]);
        $this->command->info('User Admin (admin@admin.com) has been created.');

        // \App\Models\User::factory(100)->create();
        // $this->command->info('100 User Seeding Completed.');


        $statuses = Statuses::cases();
        foreach ($statuses as $status) {
            \App\Models\Status::factory()->create([
                'status' => $status,
            ]);
        }
        $this->command->info('Status has been added.');



        // \App\Models\Vessel::factory(100)->create();
        // $this->command->info('100 Vessel Seeding Completed.');

        // \App\Models\Container::factory(100)->create();
        // $this->command->info('100 Container Seeding Completed.');

        // \App\Models\Company::factory(100)->create();
        // $this->command->info('100 Company Seeding Completed.');

        
        // \App\Models\Billoflading::factory(20)->create();
        // $this->command->info('20 Billoflading Seeding Completed.');

        // \App\Models\Bl_container::factory(2000)->create();
        // $this->command->info('2000 Bl_container Seeding Completed.');

        // \App\Models\Tracking::factory(2000)->create();
        // $this->command->info('2000 Tracking Seeding Completed.');
    }
}
