<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum CompanyTypes: string implements HasLabel, HasColor, HasIcon
{
    case WAREHOUSE = 'warehouse';
    case COMPANY = 'company';
    case BANK = 'bank';
    case CNF = 'CNF';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::WAREHOUSE => 'Warehouse',
            self::COMPANY => 'Company',
            self::BANK => 'Bank',
            self::CNF => 'CNF',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::WAREHOUSE => 'gray',
            self::COMPANY => 'success',
            self::BANK => 'danger',
            self::CNF => 'warning',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::WAREHOUSE => 'heroicon-o-home-modern',
            self::COMPANY => "heroicon-o-briefcase",
            self::BANK => "heroicon-o-building-library",
            self::CNF => "heroicon-o-document-text",
        };
    }
}