<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;

enum ContainerTypes: string implements HasLabel
{
    case DRY_STORAGE = 'dry_storage';
    case FLAT_RACK = 'flat_rack';
    case OPEN_TOP = 'open_top';
    case OPEN_SIDE_STORAGE = 'open_side_storage';
    case DOUBLE_DOORS = 'double_doors';
    case REFRIGERATED_ISO = 'refrigerated_iso';
    case INSULATED_THERMAL = 'insulated_thermal';
    case CARGO_STORAGE = 'cargo_storage';
    case HALF_HEIGHT = 'half_height';
    case CAR_CARRIERS = 'car_carriers';
    case INTERMEDIATE_BULK_SHIFT = 'intermediate_bulk_shift';
    case SPECIAL_PURPOSE = 'special_purpose';
    case SWAP_BODIES = 'swap_bodies';
    case TANKS = 'tanks';
    case DRUMS = 'drums';
    case TUNNEL = 'tunnel';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function forSelect(): array 
    {
        return array_combine(
            array_column(self::cases(), 'value'),
            array_column(self::cases(), 'name')
        );
    }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::DRY_STORAGE => 'Dry Storage',
            self::FLAT_RACK => 'Flat Rack',
            self::OPEN_TOP => 'Open Top',
            self::OPEN_SIDE_STORAGE => 'Open Side Storage',
            self::DOUBLE_DOORS => 'Double Doors',
            self::REFRIGERATED_ISO => 'Refrigerated ISO',
            self::INSULATED_THERMAL => 'Insulated / Thermal',
            self::CARGO_STORAGE => 'Cargo Storage',
            self::HALF_HEIGHT => 'Half-Height',
            self::CAR_CARRIERS => 'Car Carriers',
            self::INTERMEDIATE_BULK_SHIFT => 'Intermediate Bulk Shift',
            self::SPECIAL_PURPOSE => 'Special Purpose',
            self::SWAP_BODIES => 'Swap Bodies',
            self::TANKS => 'Tanks',
            self::DRUMS => 'Drums',
            self::TUNNEL => 'Tunnel',
        };
    }
}