<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ShipmentTypes: string implements HasLabel, HasColor, HasIcon
{
    case FCL = 'fcl';
    case CFS = 'cfs';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::FCL => 'FCL/FCL',
            self::CFS => 'CY/CFS',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::FCL => 'agent',
            self::CFS => 'success',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::FCL => 'heroicon-o-document-text',
            self::CFS => 'heroicon-o-check',
        };
    }
}