<?php

namespace App\Filament\Office\Resources\BillofladingResource\Pages;

use Filament\Actions;
use App\Models\Billoflading;
use Filament\Actions\Action;
use Filament\Actions\ActionGroup;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Office\Resources\BillofladingResource;

class EditBilloflading extends EditRecord
{

    protected static string $resource = BillofladingResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ActionGroup::make([
                Action::make('send-email')
                    ->label('Send Email')
                    // ->url(fn (Billoflading $record): string => route('filament.admin.resources.shipping.billofladings.print', $record))
                    ->url(fn (Billoflading $record): string => route('shipping.billofladings.email', $record))
                    ->icon('heroicon-o-envelope')
                    // ->color('info')
                    ->openUrlInNewTab(),
                
                Action::make('pdf')
                    ->label('PDF')
                    // ->url(fn (Billoflading $record): string => route('filament.admin.resources.shipping.billofladings.print', $record))
                    ->url(fn (Billoflading $record): string => route('shipping.billofladings.pdf', $record))
                    ->icon('heroicon-o-document')
                    // ->color('success')
                    ->openUrlInNewTab(),
                
                Action::make('print')
                    // ->url(fn (Billoflading $record): string => route('filament.admin.resources.shipping.billofladings.print', $record))
                    ->url(fn (Billoflading $record): string => route('shipping.billofladings.print', $record))
                    ->icon('heroicon-o-printer')
                    ->openUrlInNewTab(),
            ]),

            Actions\DeleteAction::make()->icon('heroicon-o-trash'),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // dd($data);
    
        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $data['last_updated_by'] = auth()->id();

        // dd($data);
    
        return $data;
    }
}
