<?php

namespace App\Filament\Office\Resources\CompanyResource\RelationManagers;

use Carbon\Carbon;
use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Support\Enums\FontWeight;
use Illuminate\Database\Eloquent\Model;
use Filament\Tables\Columns\Layout\Split;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\ContactResource\ContactForms;
use Filament\Resources\RelationManagers\RelationManager;

class ContactsRelationManager extends RelationManager
{
    protected static string $relationship = 'company_contacts';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('contact_id')
                    ->relationship('contact', 'name')
                    // ->options(\App\Models\Contact::all()->pluck('name', 'id'))
                    ->required()
                    ->searchable()
                    ->createOptionForm([
                        ContactForms::getAddForm()
                    ]),
                Forms\Components\TextInput::make('company_email')
                    ->required(),
                Forms\Components\TextInput::make('designation')
                    ->required(),
                Forms\Components\DatePicker::make('joined_at'),
                Forms\Components\RichEditor::make('note'),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Split::make([
                    Tables\Columns\ImageColumn::make('contact.pic')
                        ->circular()
                        ->grow(false),
                    Tables\Columns\TextColumn::make('contact.name')
                        ->description(fn(?Model $record):string => $record->designation)
                        ->weight(FontWeight::Bold)
                        ->searchable()
                        ->sortable(),
                    Tables\Columns\TextColumn::make('company_email')
                        ->label('Company Email')
                        ->description(fn(?Model $record):string => 'Joined ' . Carbon::parse($record->joined_at)->diffForHumans())
                        ->sortable(),
                    Tables\Columns\TextColumn::make('contact.email')
                        ->label('Personal Contact')
                        // ->formatStateUsing(fn(?Model $state):string => dd($state))
                        ->description(fn(?Model $record):string => $record->contact->phone)
                        // ->description(fn(?Model $record):string => dd($record))
                        ->searchable(),
                ]),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public function isReadOnly(): bool
    {
        return false;
    }
}
