<?php

namespace App\Filament\Office\Resources\OrganizationResource\RelationManagers;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Pages\Page;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\RelationManagers\RelationManager;

class UsersRelationManager extends RelationManager
{
    protected static string $relationship = 'users';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('email')
                    ->email()
                    ->required()
                    ->maxLength(255),
                // Forms\Components\DateTimePicker::make('email_verified_at'),
                // $this->getPasswordFormComponent(),
                // $this->getPasswordConfirmationFormComponent(),
                Forms\Components\TextInput::make('password')
                    // ->updateStateUsing(fn($record)=>dd($record))
                    ->password()
                    ->dehydrateStateUsing(static fn (null|string $state): null|string => filled($state)?Hash::make($state):null)
                    // ->required(static fn(Page $livewire): string => $livewire instanceof \Filament\Resources\Pages\CreateRecord)
                    ->dehydrated(static fn (null|string $state): bool => filled($state))
                    ->live(debounce: 500),
                    // ->label(static fn(Page $livewire): string => ($livewire instanceof \Filament\Resources\Pages\EditRecord)?'New Password':'Password')
                // Forms\Components\TextInput::make('profile_pic_path')
                //     ->maxLength(255),
                // Forms\Components\FileUpload::make('profile_pic_path')
                //     ->avatar(),
                Forms\Components\Toggle::make('is_admin'),
                // Forms\Components\TextInput::make('theme')
                //     ->maxLength(255)
                //     ->default('default'),
                // Forms\Components\TextInput::make('theme_color')
                //     ->maxLength(255),
                // CheckboxList::make('roles')
                //     ->relationship('roles', 'name')
                //     ->columns(2)
                //     ->required(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name'),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make()
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
                Tables\Actions\ForceDeleteAction::make(),
                Tables\Actions\RestoreAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                ]),
            ])
            ->modifyQueryUsing(fn (Builder $query) => $query->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]));
    }

    public function isReadOnly(): bool
    {
        return false;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $data['last_updated_by'] = auth()->id();

        dd($data);
    
        // return $data;
    }
}
