<?php

namespace App\Filament\Resources\BLResource\Pages;

use App\Filament\Resources\BLResource;
use App\Models\Office;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateBL extends CreateRecord
{
    protected static string $resource = BLResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        $data['delivery_agent_id'] = $office?$office->id:null;

        $data['entry_by_user_id'] = auth()->id();
        $data['organization_id'] = auth()->user()->organization_id;
        // dd($data);

        return $data;
    }
}
