<?php

namespace App\Filament\Resources\BLResource\Pages;

use Filament\Actions;
use App\Models\Office;
use App\Filament\Resources\BLResource;
use Filament\Resources\Pages\EditRecord;

class EditBL extends EditRecord
{
    protected static string $resource = BLResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        $data['delivery_agent_id'] = $office?$office->id:null;

        $data['last_updated_by_user_id'] = auth()->id();
    
        return $data;
    }

    public function getTitle(): string
    {
        return 'Edit ' . $this->getRecordTitle() . ' #' . $this->getRecord()->bl_no;
    }
}
