<?php

namespace App\Models;

use App\Enums\CompanyTypes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Company extends Model
{
    use HasFactory, SoftDeletes;

    protected $casts = [
        'type' => CompanyTypes::class,
    ];
    
    /**
     * The "booted" method of the model.
     */
    protected static function booted(): void
    {
        // dd(Company::where('organization_id', auth()->user()->organization_id));
        static::addGlobalScope('organization', function (Builder $builder) {
            $builder->where('organization_id', auth()->user()->organization_id);
        });
    }

    /**
     * Get the country that owns the City
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    /**
     * Get the state that owns the City
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    /**
     * Get the state that owns the City
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }

    /**
     * Get all of the bl_containers for the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bl(): HasMany
    {
        return $this->hasMany(Billoflading::class, 'company_id');
    }
}
